// 【シリアル通信のラッパー】
int serial_available() {
  if (Wireless) return XBee.available();
  return Serial.available();
}
void serial_begin(long bps) {
  if (Wireless) XBee.begin(bps);
    else        Serial.begin(bps);
}
int serial_peek() {
  if (Wireless) return XBee.peek();
  return Serial.peek();
}
int serial_read() {
  if (Wireless) return XBee.read();
  return Serial.read();
}
long serial_print(String str) {
  if (Wireless) XBee.print(str);
    else        Serial.print(str);
  return str.length();
}
long serial_print(int a) {
  if (Wireless) XBee.print(String(a));
    else          Serial.print(a);
  return String(a).length();
}
// format : DEC, HEX, BIN
long serial_print(int a, int format) {
  if (Wireless) XBee.print(a, format);
    else        Serial.print(a, format);
  return String(a, format).length();
}
long serial_print(float f, int point) {
  if (Wireless) XBee.print(String(f, point));
    else        Serial.print(f, point);
  return String(f, point).length();
}
long serial_println(String str) {
  if (Wireless) XBee.println(str);
    else        Serial.println(str);
  return str.length();
}
long serial_println(int a) {
  if (Wireless) XBee.println(String(a));
    else          Serial.println(a);
  return String(a).length();
}
// format : DEC, HEX, BIN
long serial_println(int a, int format) {
  if (Wireless) XBee.println(a, format);
    else        Serial.println(a, format);
  return String(a, format).length();
}
long serial_println(float f, int point) {
  if (Wireless) XBee.println(String(f, point));
    else        Serial.println(f, point);
  return String(f, point).length();
}
int serial_write(int val) {
  if (Wireless) XBee.write(val);
    else        Serial.write(val);
  return 1;
}
/*
int serial_write(String str) {
  if (Wireless) {
    int len = str.length();
    for (int i = 0; i < len; i++) XBee.write(str.charAt(i));
  } else        Serial.write(str);
  return str.length();
}
*/
